/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.utils;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.utils.resources.VWSIMResource;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Hashtable;

public class VWSIMLauncher {
    private static Integer SIMULATION_LIFE_SPAN = 2;
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private VWSIMPropertyData m_propertyData = null;
    private IVWSIMSimulation m_simulation = null;
    private IVWIDMDocument m_selectedDoc = null;
    private String m_simName = null;
    private String m_simDesc = null;
    private String m_simLibId = null;
    private String m_simId = null;
    private String m_title = null;
    private IVWIDMFolder[] m_folderList = null;

    public VWSIMLauncher(Frame parentFrame, VWSession session) {
        this.m_parentFrame = parentFrame;
        this.m_session = session;
        try {
            VWIDMBaseFactory.instance();
            this.m_title = VWSIMResource.s_startSimulation;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWSIMLauncher(VWSIMPropertyData propertyData) {
        this(propertyData.getParentFrame(), propertyData.getSessionInfo().getSession());
        this.m_propertyData = propertyData;
    }

    public IVWSIMSimulation getSimulation() {
        return this.m_simulation;
    }

    public IVWIDMFolder[] getFoldersFiledIn() {
        return this.m_folderList;
    }

    public int getSimulationStatus() throws Exception {
        int simStatus = -1;
        simStatus = this.m_simulation.getStatus();
        return simStatus;
    }

    public String getSimulationFailureMessage() throws Exception {
        return this.m_simulation.getSimulationFailureMessage();
    }

    public String getSimulationName() {
        return this.m_simName;
    }

    public String getSimulationId() {
        return this.m_simId;
    }

    public String getSimulationLibId() {
        return this.m_simLibId;
    }

    public String getSimulationDesc() {
        return this.m_simDesc;
    }

    public boolean startSimulation(VWScenarioDefinition scenarioDef, IVWSIMScenario scenario, IVWIDMItem folderItem) throws Exception {
        boolean success;
        block7: {
            success = false;
            try {
                String description;
                IVWIDMFactory factory;
                if (this.m_parentFrame == null || scenarioDef == null || this.m_session == null || scenario == null || folderItem == null) break block7;
                StringBuffer runtimeXMLBuffer = new StringBuffer();
                VWSystemConfiguration sysConfig = null;
                if (this.m_propertyData != null) {
                    sysConfig = this.m_propertyData.getSystemConfiguration();
                }
                scenarioDef.toRuntimeXML(this.m_session, sysConfig, runtimeXMLBuffer);
                String runtimeXML = runtimeXMLBuffer.toString();
                if (runtimeXML == null || runtimeXML.length() <= 0 || (factory = VWIDMBaseFactory.instance()) == null) break block7;
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                String name = scenarioDef.getName();
                if (name == null) {
                    name = "";
                }
                if ((description = scenarioDef.getDescription()) == null) {
                    description = "";
                }
                properties.put("DocumentTitle", name);
                properties.put("SimulationDescription", description);
                properties.put("PublishingEnabled", scenarioDef.getCollectAnalyisData());
                properties.put("SimulationLifeSpanInHours", SIMULATION_LIFE_SPAN);
                this.m_parentFrame.setCursor(new Cursor(3));
                IVWIDMDialog dialog = factory.getAddDialog(this.m_parentFrame, folderItem, runtimeXML.getBytes("UTF8"), "Simulation", properties);
                this.m_parentFrame.setCursor(new Cursor(0));
                if (dialog == null) break block7;
                dialog.setTitle(this.m_title);
                dialog.setFilename(name);
                int retVal = dialog.showDialog(this.m_parentFrame);
                if (retVal != 0) break block7;
                this.m_parentFrame.setCursor(new Cursor(3));
                this.m_selectedDoc = (IVWIDMDocument)dialog.getSelectedItem();
                this.m_folderList = this.m_selectedDoc.getFoldersFiledIn();
                VWSIMSession simSession = new VWSIMSession();
                this.m_simName = (String)this.m_selectedDoc.getProp("DocumentTitle");
                this.m_simDesc = (String)this.m_selectedDoc.getProp("SimulationDescription");
                this.m_simLibId = this.m_selectedDoc.getLibraryId();
                this.m_simId = this.m_selectedDoc.getId();
                String serviceName = this.m_session.getServerName();
                int regionId = this.m_session.getIsolatedRegion();
                try {
                    this.m_simulation = simSession.createSimulation(this.m_simName, this.m_simDesc, serviceName, regionId, scenario, this.m_simLibId, this.m_simId);
                    this.m_simulation.start();
                    this.m_simId = this.m_simulation.getSimulationDocId();
                    success = true;
                }
                catch (Exception ex) {
                    this.m_selectedDoc.delete();
                    throw ex;
                }
                this.m_parentFrame.setCursor(new Cursor(0));
            }
            catch (Exception ex) {
                this.m_parentFrame.setCursor(new Cursor(0));
                throw ex;
            }
        }
        return success;
    }
}

